package ACDesign "Air conditioning example"
  model ACDesignModel "Model of the building attached to the ambient and a controller"
    extends Modelica.Icons.Example;
    Modelica.Blocks.Sources.CombiTimeTable outsideTemp(table = {{0, 20}, {2, 22}, {4, 24}, {6, 28}, {8, 32}, {10, 35}, {12, 36}, {14, 32}, {16, 30}, {18, 25}, {20, 24}, {22, 20}, {24, 20}}, timeScale(displayUnit = "h") = 3600) annotation(
        Placement(visible = true, transformation(origin = {-50, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
      );
    Components.LivingRoom building(coolingLoad.k = 100, airConditioner.maxFlowRate.k = 0.000025, roomInertia.C = 100000.0, orientation = 4) annotation(
        Placement(visible = true, transformation(origin = {-10, -0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
      );
    Components.Controller controller annotation(
        Placement(visible = true, transformation(origin = {40, -0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
      );
  equation
    connect(building.temp, controller.signal) annotation(
        Line(visible = true, origin = {32.8, -10.2}, points = {{-42.8, -0.8}, {-42.8, -9.8}, {32.2, -9.8}, {32.2, 10.2}, {19.2, 10.2}}, color = {1, 37, 163})
      );
    connect(outsideTemp.y[1], building.ambient) annotation(
        Line(visible = true, origin = {-30.5, -0}, points = {{-8.5, 0}, {8.5, -0}}, color = {1, 37, 163})
      );
    connect(building.controlSignal, controller.y) annotation(
        Line(visible = true, origin = {15.5, -0}, points = {{-13.5, -0}, {13.5, 0}}, color = {190, 52, 178})
      );
    annotation(
      preferredView = "info",
      experiment(
        StopTime = 86400,
        __Wolfram_DisplayTimeUnit = "h"
      ),
      Documentation(
        info = "<html>

    <p>
Model of the the building fed with external weather data. The room temperature is controlled by using an On/Off controller.
</p></html>",
        figures = {
          Figure(
            title = "results",
            identifier = "85f9c",
            preferred = true,
            plots = {
              Plot(
                curves = {
                  Curve(y = building.roomInertia.T, legend = "room temperature"),
                  Curve(y = building.ambient, legend = "ambient temperature")
                },
                y = Axis(min = 5, max = 40)
              )
            }
          ),
          Figure(
            title = "cumulative energy in kWhr",
            identifier = "a2f05",
            plots = {
              Plot(
                curves = {
                  Curve(y = building.airConditioner.tokJ.y, legend = "cumulative energy")
                }
              )
            }
          )
        }
      ),
      Diagram(
        coordinateSystem(extent = {{-80, -30}, {80, 25}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
      )
    );
  end ACDesignModel;

  package Components "Package containing components for the air conditionaing example"
    extends Modelica.Icons.Package;

    model LivingRoom "Models the living room"
      Components.MyNet loadPredictor annotation(
          Placement(visible = true, transformation(origin = {-230, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Sources.PrescribedHeatFlow heatToRoom annotation(
          Placement(visible = true, transformation(origin = {-150, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Sources.Constant houseParameters[8](k = {relativeCompactness, surfaceArea, wallArea, roofArea, overallHeight, orientation, glazingArea, glazingAreaDistribution}) annotation(
          Placement(visible = true, transformation(origin = {-270, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      parameter Real relativeCompactness = 0.76 "relative compactness of the building";
      parameter Real surfaceArea = 514.5 "surface area in sq. m";
      parameter Real wallArea = 294 "area of wall in sq. m";
      parameter Real roofArea = 110.25 "area of roof in sq. m";
      parameter Real overallHeight = 7 "overall height in m";
      parameter Real orientation = 2 "1: North 2: South 3: East 4: West";
      parameter Real glazingArea = 0 "total glazing area in sq. m";
      parameter Real glazingAreaDistribution = 0 "total glazing area in %";
      Modelica.Thermal.HeatTransfer.Components.ThermalConductor floor(G = 0.2 * 100 / 40) annotation(
          Placement(visible = true, transformation(origin = {-130, -60}, extent = {{-10, -10}, {10, 10}}, rotation = -450))
        );
      Modelica.Thermal.HeatTransfer.Components.HeatCapacitor roomInertia(T.start = 292, C(start = 90000) = 200000, T.fixed = true) annotation(
          Placement(visible = true, transformation(origin = {-100, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Interfaces.RealInput ambient annotation(
          Placement(visible = true, transformation(origin = {-280, -0}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Celsius.FixedTemperature groundTemperature(T = 4) annotation(
          Placement(visible = true, transformation(origin = {-170, -80}, extent = {{10, -10}, {-10, 10}}, rotation = 180))
        );
      Modelica.Thermal.HeatTransfer.Celsius.PrescribedTemperature tempAmbient1 annotation(
          Placement(visible = true, transformation(origin = {-210, -0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Celsius.TemperatureSensor temperature annotation(
          Placement(visible = true, transformation(origin = {-70, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -360))
        );
      DocumentationExamples.Modeling.RoomHeating.Components.Walls walls annotation(
          Placement(visible = true, transformation(origin = {-170, -0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Celsius.PrescribedTemperature tempAmbient2 annotation(
          Placement(visible = true, transformation(origin = {-150, 90}, extent = {{-10, -10}, {10, 10}}, rotation = -360))
        );
      DocumentationExamples.Modeling.RoomHeating.Components.Walls roof annotation(
          Placement(visible = true, transformation(origin = {-130, 50}, extent = {{-10, -10}, {10, 10}}, rotation = -90))
        );
      Modelica.Blocks.Math.Gain coolingLoad(k = 10) annotation(
          Placement(visible = true, transformation(origin = {-190, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      AC airConditioner annotation(
          Placement(visible = true, transformation(origin = {-170, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Interfaces.RealOutput temp annotation(
          Placement(visible = true, transformation(origin = {-40, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90))
        );
      Modelica.Blocks.Interfaces.BooleanInput controlSignal annotation(
          Placement(visible = true, transformation(origin = {-220, 40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {120, 0}, extent = {{-20, -20}, {20, 20}}, rotation = -180))
        );
    equation
      connect(houseParameters.y, loadPredictor.u) annotation(
          Line(visible = true, origin = {-250.5, -40}, points = {{-8.5, 0}, {8.5, 0}}, color = {1, 37, 163})
        );
      connect(ambient, tempAmbient1.T) annotation(
          Line(visible = true, origin = {-251, -0}, points = {{-29, -0}, {29, 0}}, color = {0, 36, 164})
        );
      connect(tempAmbient1.port, walls.outside) annotation(
          Line(visible = true, origin = {-190.5, -0}, points = {{-9.5, 0}, {9.5, 0}}, color = {191, 0, 0})
        );
      connect(floor.port_b, groundTemperature.port) annotation(
          Line(visible = true, origin = {-140, -76.667}, points = {{10, 6.667}, {10, -3.333}, {-20, -3.333}}, color = {191, 0, 0})
        );
      connect(ambient, tempAmbient2.T) annotation(
          Line(visible = true, origin = {-202, 54.4}, points = {{-78, -54.4}, {-38, -54.4}, {-38, 35.6}, {40, 35.6}}, color = {1, 37, 163})
        );
      connect(coolingLoad.y, heatToRoom.Q_flow) annotation(
          Line(visible = true, origin = {-169.5, -40}, points = {{-9.5, 0}, {9.5, 0}}, color = {1, 37, 163})
        );
      connect(loadPredictor.y[1], coolingLoad.u) annotation(
          Line(visible = true, origin = {-210.5, -40}, points = {{-8.5, -0}, {8.5, 0}}, color = {1, 37, 163})
        );
      connect(tempAmbient2.port, roof.outside) annotation(
          Line(visible = true, origin = {-133.333, 80.333}, points = {{-6.667, 9.667}, {3.333, 9.667}, {3.333, -19.333}}, color = {191, 0, 0})
        );
      connect(roomInertia.port, temperature.port) annotation(
          Line(visible = true, origin = {-93.333, 13.333}, points = {{-6.667, 6.667}, {-6.667, -3.333}, {13.333, -3.333}}, color = {191, 0, 0})
        );
      connect(temperature.T, temp) annotation(
          Line(visible = true, origin = {-50, 10}, points = {{-10, 0}, {10, 0}}, color = {1, 37, 163})
        );
      connect(airConditioner.controlSignal, controlSignal) annotation(
          Line(visible = true, origin = {-207.333, 40.226}, points = {{25.333, 0.113}, {-12.667, 0.113}, {-12.667, -0.226}}, color = {190, 52, 178})
        );
      connect(roof.inside, roomInertia.port) annotation(
          Line(visible = true, origin = {-115, 21.842}, points = {{-15, 17.158}, {-15, -11.842}, {15, -11.842}, {15, -1.842}}, color = {191, 0, 0})
        );
      connect(walls.inside, roomInertia.port) annotation(
          Line(visible = true, origin = {-119.667, 6.667}, points = {{-39.333, -6.667}, {19.667, -6.667}, {19.667, 13.333}}, color = {191, 0, 0})
        );
      connect(floor.port_a, roomInertia.port) annotation(
          Line(visible = true, origin = {-115, -2.079}, points = {{-15, -47.921}, {-15, 12.079}, {15, 12.079}, {15, 22.079}}, color = {191, 0, 0})
        );
      connect(airConditioner.heatPort, roof.inside) annotation(
          Line(visible = true, origin = {-146, 31.8}, points = {{-14, 8.2}, {-4, 8.2}, {-4, -21.8}, {16, -21.8}, {16, 7.2}}, color = {191, 0, 0})
        );
      connect(heatToRoom.port, roomInertia.port) annotation(
          Line(visible = true, origin = {-132, -10}, points = {{-8, -30}, {2, -30}, {2, 20}, {32, 20}, {32, 30}}, color = {191, 0, 0})
        );
      annotation(
        Documentation(
          info = "<html>

    <p>
Model of the living room connected with the neural net. The model can be fed with ambient temperature data. The heat storage capacity of the room is represented by a heat capacitor.
</p></html>"
        ),
        Icon(
          coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {10, 10}),
          graphics = {
            Rectangle(visible = true, fillColor = {205, 144, 0}, fillPattern = FillPattern.Solid, extent = {{-100, -100}, {100, 100}}),
            Rectangle(visible = true, fillColor = {255, 246, 207}, fillPattern = FillPattern.Solid, extent = {{-90, -90}, {90, 90}}),
            Rectangle(visible = true, origin = {-95, 20}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-5, -30}, {5, 30}}),
            Ellipse(visible = true, origin = {50, 50}, fillColor = {255, 255, 255}, extent = {{-20, -20}, {20, 20}}),
            Polygon(visible = true, origin = {9.934, 49.304}, fillColor = {255, 255, 255}, points = {{7.491, 9.504}, {7.491, -8.985}, {-7.491, -6.199}, {-7.491, 5.679}}),
            Rectangle(visible = true, origin = {-0.066, 48.926}, fillColor = {255, 255, 255}, extent = {{-2.509, -8.926}, {2.509, 8.926}}),
            Polygon(visible = true, origin = {50.26, 12.509}, rotation = -270, fillColor = {255, 255, 255}, points = {{7.491, 9.504}, {7.491, -8.985}, {-7.491, -6.199}, {-7.491, 5.679}}),
            Rectangle(visible = true, origin = {50, 2.509}, rotation = -270, fillColor = {255, 255, 255}, extent = {{-2.509, -8.926}, {2.509, 8.926}}),
            Text(visible = true, origin = {0, 130}, extent = {{-100, -29.021}, {100, 29.021}}, textString = "%name", fontName = "Arial")
          }
        ),
        Diagram(
          coordinateSystem(extent = {{-295, -100}, {-25, 107.367}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
        )
      );
    end LivingRoom;

    block MyNet "Model of the neural net"
      extends SystemModelerExtras.NeuralNet.Components.MIMO_ONNXNet(fileName = Modelica.Utilities.Files.loadResource("modelica://ACDesign.Components.MyNet/MyNet.onnx"), nin = 8, nout = 2);
      annotation(
        Documentation(
          info = "<html>

    <p>
Model of the neural net. This is an input-output block that can be connected to other models.
</p></html>"
        ),
        Diagram(
          coordinateSystem(extent = {{-150, -90}, {150, 90}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
        )
      );
    end MyNet;

    model AC "Air conditioning"
      Modelica.Blocks.Sources.Constant maxFlowRate(k = 0.01) annotation(
          Placement(visible = true, transformation(origin = {-110, 90}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Thermal.FluidHeatFlow.Components.Pipe heatingRefrigerant(h_g = 0, m = 0, T0 = 263.15, dpLaminar = 0, dpNominal = 0, V_flowLaminar = 0.1, V_flowNominal = 1, T.fixed = false, medium = medium, useHeatPort = true) annotation(
          Placement(visible = true, transformation(origin = {30, 40}, extent = {{10, 10}, {-10, -10}}, rotation = 0))
        );
      Modelica.Thermal.FluidHeatFlow.Sources.Ambient source(constantAmbientPressure = 100000, constantAmbientTemperature = 268.15, medium = medium) annotation(
          Placement(visible = true, transformation(origin = {-50, 40}, extent = {{-10, -10}, {10, 10}}, rotation = -180))
        );
      Modelica.Thermal.FluidHeatFlow.Sources.Ambient sink(constantAmbientPressure = 100000, constantAmbientTemperature = 278.15, medium = medium) annotation(
          Placement(visible = true, transformation(origin = {70, 40}, extent = {{-10, 10}, {10, -10}}, rotation = 0))
        );
      Modelica.Thermal.FluidHeatFlow.Sources.VolumeFlow pump(constantVolumeFlow = 0.1, m = 0, T0 = 263.15, medium = medium, useVolumeFlowInput = true) annotation(
          Placement(visible = true, transformation(origin = {-10, 40}, extent = {{-10, -10}, {10, 10}}, rotation = -360))
        );
      Modelica.Thermal.HeatTransfer.Celsius.TemperatureSensor tempSensor annotation(
          Placement(visible = true, transformation(origin = {10, 100}, extent = {{10, -10}, {-10, 10}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPort annotation(
          Placement(visible = true, transformation(origin = {100, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {100, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      parameter Modelica.Thermal.FluidHeatFlow.Media.Medium medium = Modelica.Thermal.FluidHeatFlow.Media.Gylcol20_20degC() "Refrigerant";
      Modelica.Blocks.Logical.Switch switch1 annotation(
          Placement(visible = true, transformation(origin = {-70, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Sources.Constant minFlowRate(k = 0) annotation(
          Placement(visible = true, transformation(origin = {-110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Interfaces.BooleanInput controlSignal annotation(
          Placement(visible = true, transformation(origin = {-140, 70}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 3.386}, extent = {{-20, -20}, {20, 20}}, rotation = 0))
        );
      Modelica.Thermal.HeatTransfer.Sensors.HeatFlowSensor heatFlowSensor annotation(
          Placement(visible = true, transformation(origin = {60, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Math.Abs abs annotation(
          Placement(visible = true, transformation(origin = {90, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Continuous.Integrator integrator annotation(
          Placement(visible = true, transformation(origin = {120, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Math.Gain tokJ(k = 0.001 / 3600, y.unit = "kW.h") annotation(
          Placement(visible = true, transformation(origin = {150, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
    equation
      connect(heatingRefrigerant.flowPort_a, sink.flowPort) annotation(
          Line(visible = true, origin = {50, 40}, points = {{-10, 0}, {10, 0}}, color = {255, 0, 0})
        );
      connect(source.flowPort, pump.flowPort_a) annotation(
          Line(visible = true, origin = {-30, 40}, points = {{-10, 0}, {10, 0}}, color = {255, 0, 0})
        );
      connect(heatingRefrigerant.heatPort, tempSensor.port) annotation(
          Line(visible = true, origin = {26.667, 83.333}, points = {{3.333, -33.333}, {3.333, 16.667}, {-6.667, 16.667}}, color = {191, 0, 0})
        );
      connect(pump.flowPort_b, heatingRefrigerant.flowPort_b) annotation(
          Line(visible = true, origin = {10, 40}, points = {{-10, 0}, {10, 0}}, color = {190, 20, 31})
        );
      connect(switch1.y, pump.volumeFlow) annotation(
          Line(visible = true, origin = {-26.333, 63.333}, points = {{-32.667, 6.667}, {16.333, 6.667}, {16.333, -13.333}}, color = {1, 37, 163})
        );
      connect(maxFlowRate.y, switch1.u1) annotation(
          Line(visible = true, origin = {-90.25, 84}, points = {{-8.75, 6}, {0.25, 6}, {0.25, -6}, {8.25, -6}}, color = {1, 37, 163})
        );
      connect(minFlowRate.y, switch1.u3) annotation(
          Line(visible = true, origin = {-90.25, 51}, points = {{-8.75, -11}, {0.25, -11}, {0.25, 11}, {8.25, 11}}, color = {1, 37, 163})
        );
      connect(switch1.u2, controlSignal) annotation(
          Line(visible = true, origin = {-111, 70}, points = {{29, 0}, {-29, 0}}, color = {190, 52, 178})
        );
      connect(heatingRefrigerant.heatPort, heatFlowSensor.port_a) annotation(
          Line(visible = true, origin = {36.667, 70}, points = {{-6.667, -20}, {-6.667, 10}, {13.333, 10}}, color = {191, 0, 0})
        );
      connect(heatFlowSensor.port_b, heatPort) annotation(
          Line(visible = true, origin = {85, 80}, points = {{-15, 0}, {15, 0}}, color = {191, 0, 0})
        );
      connect(heatFlowSensor.Q_flow, abs.u) annotation(
          Line(visible = true, origin = {66, 63.333}, points = {{-6, 6.667}, {-6, -3.333}, {12, -3.333}}, color = {1, 37, 163})
        );
      connect(abs.y, integrator.u) annotation(
          Line(visible = true, origin = {104.5, 60}, points = {{-3.5, 0}, {3.5, 0}}, color = {1, 37, 163})
        );
      connect(integrator.y, tokJ.u) annotation(
          Line(visible = true, origin = {134.5, 60}, points = {{-3.5, 0}, {3.5, -0}}, color = {1, 37, 163})
        );
      annotation(
        Documentation(
          info = "<html>

    <p>
The model consists of a fluid circuit that absorbs heat from the room. The mass flow rate is controlled by the control signal to control the rate of heat extraction.
</p></html>"
        ),
        Diagram(
          coordinateSystem(extent = {{-155, 0}, {165, 135}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
        ),
        Icon(
          coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {10, 10}),
          graphics = {
            Text(visible = true, textColor = {64, 64, 64}, extent = {{-150, 110}, {150, 150}}, textString = "%name"),
            Bitmap(visible = true, fileName = "", imageSource = "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
", extent = {{-100, -100}, {100, 100}})
          }
        )
      );
    end AC;

    model Controller "Models a thermostat switching heating on and off"
      Modelica.Blocks.Sources.Constant reference(k = 20) annotation(
          Placement(visible = true, transformation(origin = {-30, 10}, extent = {{10, 10}, {-10, -10}}, rotation = 180))
        );
      Modelica.Blocks.Interfaces.RealInput signal annotation(
          Placement(visible = true, transformation(origin = {-52.5, -20}, extent = {{-12.5, -12.5}, {12.5, 12.5}}, rotation = 0), iconTransformation(origin = {120, 0}, extent = {{-20, -20}, {20, 20}}, rotation = -180))
        );
      Modelica.Blocks.Logical.OnOffController onOffController(bandwidth = 2) annotation(
          Placement(visible = true, transformation(origin = {10, -5}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
      Modelica.Blocks.Interfaces.BooleanOutput y annotation(
          Placement(visible = true, transformation(origin = {90, -5}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -180))
        );
      Modelica.Blocks.Logical.Not invertSignal annotation(
          Placement(visible = true, transformation(origin = {50, -5}, extent = {{-10, -10}, {10, 10}}, rotation = 0))
        );
    equation
      connect(reference.y, onOffController.reference) annotation(
          Line(visible = true, origin = {-11.868, 5.5}, points = {{-7.132, 4.5}, {1.868, 4.5}, {1.868, -4.5}, {9.868, -4.5}}, color = {1, 37, 163})
        );
      connect(signal, onOffController.u) annotation(
          Line(visible = true, origin = {-18.625, -15.5}, points = {{-33.875, -4.5}, {8.625, -4.5}, {8.625, 4.5}, {16.625, 4.5}}, color = {1, 37, 163})
        );
      connect(onOffController.y, invertSignal.u) annotation(
          Line(visible = true, origin = {29.5, -5}, points = {{-8.5, 0}, {8.5, 0}}, color = {255, 0, 255})
        );
      connect(invertSignal.y, y) annotation(
          Line(visible = true, origin = {75.5, -5}, points = {{-14.5, 0}, {14.5, 0}}, color = {255, 0, 255})
        );
      annotation(
        Documentation(
          info = "<html>


    <p>
The controller is modelled as an On/Off controller.
</p></html>"
        ),
        Icon(
          coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {10, 10}),
          graphics = {
            Text(visible = true, origin = {-0, 130}, extent = {{-100, -29.021}, {100, 29.021}}, textString = "%name", fontName = "Arial"),
            Ellipse(visible = true, lineColor = {128, 0, 0}, fillColor = {182, 0, 0}, fillPattern = FillPattern.Sphere, extent = {{-70, -70}, {70, 70}}),
            Line(visible = true, origin = {0, 85}, points = {{0, 5}, {0, -5}}, thickness = 1.5),
            Line(visible = true, origin = {55, 65}, points = {{-5, -5}, {5, 5}}, color = {200, 0, 0}, thickness = 1.5),
            Line(visible = true, origin = {-55, 65}, points = {{5, -5}, {-5, 5}}, color = {0, 0, 255}, thickness = 1.5),
            Polygon(visible = true, rotation = -34.311, fillColor = {255, 255, 255}, pattern = LinePattern.None, fillPattern = FillPattern.VerticalCylinder, points = {{-20, 48.454}, {0, 60}, {20, 50}, {0, -50}})
          }
        ),
        Diagram(
          coordinateSystem(extent = {{-65, -35}, {98.164, 35}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
        )
      );
    end Controller;
    annotation(
      Documentation,
      Diagram(
        coordinateSystem(extent = {{-148.5, -105.0}, {148.5, 105.0}}, preserveAspectRatio = true, initialScale = 0.1, grid = {5, 5})
      )
    );
  end Components;
  annotation(
    preferredView = "info",
    uses(
      Modelica(
        version = "4.0.0"
      )
    ),
    __Wolfram(
      openClass = ACDesign.ACDesignModel
    ),
    Documentation(
      info = "<html>

    <p>
Which building properties affect the energy spent in air conditioning? This example uses data from 768 diverse residential buildings to predict their air conditioning's thermal load by training a neural network. The neural net is connected with thermal modeling components to study the effect of building orientation.
</p>
<div>
<p>In order to get the full experience of this example, you need a desktop Wolfram Language product. A free trial download is available at <a href=\"http://www.wolfram.com/mathematica/trial/\">www.wolfram.com/mathematica/trial/</a></p>
<p>For the full example, open the accompanying notebook <a href=\"modelica://ACDesign/ACDesign.nb\">ACDesign.nb</a>.</p>
</div>

</html>"
    ),
    Icon(
      coordinateSystem(extent = {{-100.0, -100.0}, {100.0, 100.0}}, preserveAspectRatio = true, initialScale = 0.1, grid = {10, 10}),
      graphics = {
        Rectangle(visible = true, lineColor = {111, 0, 0}, fillColor = {255, 0, 0}, fillPattern = FillPattern.HorizontalCylinder, lineThickness = 4, extent = {{-90.0, -90.0}, {90.0, 90.0}}, radius = 25),
        Text(visible = true, origin = {12.0, 20.8333}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-102.0, -70.8333}, {78.0, 29.1667}}, textString = "Ex", fontName = "Arial")
      }
    )
  );
end ACDesign;
